# DB-WhySoHeavy 数据库管理系统

## 简介

DB-WhySoHeavy 是一款专业的 MySQL 数据库管理工具，提供直观的图形界面和强大的数据库操作功能。

## 系统要求

### Windows
- Windows 10 或更高版本
- 64位操作系统

### macOS
- macOS 10.15 (Catalina) 或更高版本
- Intel 或 Apple Silicon 处理器

### Linux
- Ubuntu 18.04+ / CentOS 7+ / Debian 10+
- 64位操作系统
- GLIBC 2.17 或更高版本

## 安装说明

### Windows
1. 解压下载的 ZIP 文件
2. 双击运行 `dbwhysoheavy-windows.exe`
3. 如果出现安全提示，选择"仍要运行"

### macOS
1. 解压下载的 ZIP 文件
2. 打开终端，进入解压目录
3. 运行命令：`chmod +x dbwhysoheavy-macos`
4. 运行命令：`./dbwhysoheavy-macos`
5. **如果遇到安全提示解决方法**：
   - **方法一（推荐）**：打开"系统设置" > "隐私与安全" > 在"安全性"部分找到被阻止的应用 > 点击"仍要打开"
   - **方法二（命令行）**：在终端中运行 `xattr -d com.apple.quarantine dbwhysoheavy-macos` 移除隔离属性
   - **方法三**：如果仍有问题，可以在"系统设置" > "隐私与安全" > "开发者工具"中添加终端应用的权限

### Linux
1. 解压下载的 ZIP 文件
2. 打开终端，进入解压目录
3. 运行命令：`chmod +x dbwhysoheavy-linux`
4. 运行命令：`./dbwhysoheavy-linux`

## 首次使用

1. **获取激活码**
   - 访问 [激活页面](https://db.whysoheavy.com/get-activation/)
   - 输入软件显示的客户端 UUID
   - 获取并复制激活码

2. **激活软件**
   - 启动软件后，在激活界面输入激活码
   - 点击"激活"按钮完成激活

3. **连接数据库**
   - 输入 MySQL 服务器地址
   - 输入用户名和密码
   - 选择要连接的数据库
   - 点击"连接"按钮

## 主要功能

- **数据库连接管理**：支持多个 MySQL 服务器连接
- **表结构查看**：直观显示表结构和字段信息
- **数据查询**：支持 SQL 查询和可视化数据浏览
- **数据编辑**：支持数据的增删改操作
- **导入导出**：支持数据的导入和导出功能
- **性能监控**：实时监控数据库性能指标

## 常见问题

### Q: 软件无法启动怎么办？
A: 请检查系统要求，确保操作系统版本符合要求。在 Linux/macOS 上确保文件有执行权限。

### Q: 激活码无效怎么办？
A: 请确保输入的激活码完整且正确，激活码区分大小写。如果问题持续，请联系技术支持。

### Q: 无法连接数据库怎么办？
A: 请检查网络连接、数据库服务器地址、用户名密码是否正确，以及数据库服务是否正常运行。

## 技术支持

如果您在使用过程中遇到问题，请通过以下方式联系我们：

- 官方网站：https://db.whysoheavy.com
- 技术支持邮箱：support@whysoheavy.com
- 在线文档：https://docs.whysoheavy.com

## 版权信息

Copyright © 2024 WhySoHeavy Team. All rights reserved.

本软件受版权法保护，未经授权不得复制、分发或修改。